/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authc.rest.ClientAddressAscertainer;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.rest.RestRequestMetaData;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.ApiAuthenticationProcessor;
import com.floragunn.searchguard.authc.session.FrontendAuthcConfig;
import com.floragunn.searchguard.authc.session.backend.InvalidTokenException;
import com.floragunn.searchguard.authc.session.backend.MergedAuthcConfig;
import com.floragunn.searchguard.authc.session.backend.NoSuchSessionException;
import com.floragunn.searchguard.authc.session.backend.PushSessionTokenUpdateAction;
import com.floragunn.searchguard.authc.session.backend.SessionActivityTracker;
import com.floragunn.searchguard.authc.session.backend.SessionApi;
import com.floragunn.searchguard.authc.session.backend.SessionCreationException;
import com.floragunn.searchguard.authc.session.backend.SessionPrivileges;
import com.floragunn.searchguard.authc.session.backend.SessionServiceConfig;
import com.floragunn.searchguard.authc.session.backend.SessionToken;
import com.floragunn.searchguard.authc.session.backend.SessionUpdateException;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.indices.IndexCleanupAgent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.BaseEncoding;
import inet.ipaddr.IPAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class SessionService {
    private static final Logger log = LogManager.getLogger(SessionService.class);
    public static final StaticSettings.Attribute<String> INDEX_NAME = StaticSettings.Attribute.define((String)"searchguard.sessions.index.name").withDefault(".searchguard_sessions").asString();
    public static final StaticSettings.Attribute<TimeValue> CLEANUP_INTERVAL = StaticSettings.Attribute.define((String)"searchguard.sessions.cleanup_interval").withDefault(TimeValue.timeValueHours((long)1L)).asTimeValue();
    public static final String USER_TYPE = "session";
    private final PrivilegedConfigClient privilegedConfigClient;
    private final Cache<String, SessionToken> idToAuthTokenMap = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private final ThreadPool threadPool;
    private final ThreadContext threadContext;
    private final String indexName;
    private final AdminDNs adminDns;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final AuditLog auditLog;
    private final BlockedIpRegistry blockedIpRegistry;
    private final BlockedUserRegistry blockedUserRegistry;
    private final ClusterService clusterService;
    private final ComponentState componentState;
    private final ComponentState configComponentState;
    private final TimeAggregation startAuthenticatedSessionMetrics = new TimeAggregation.Milliseconds();
    private final TimeAggregation startSessionMetrics = new TimeAggregation.Milliseconds();
    private final TimeAggregation deleteMetrics = new TimeAggregation.Milliseconds();
    private SessionActivityTracker activityTracker;
    private IndexCleanupAgent indexCleanupAgent;
    private long maxTokensPerUser = 100L;
    private SessionServiceConfig config;
    private JoseJwtProducer jwtProducer;
    private JsonWebKey encryptionKey;
    private JsonWebKey signingKey;
    private JwsSignatureVerifier jwsSignatureVerifier;
    private JweDecryptionProvider jweDecryptionProvider;
    private String jwtAudience;
    private boolean initialized = false;
    private volatile MergedAuthcConfig authcConfig;
    private volatile ClientAddressAscertainer clientAddressAscertainer;
    private List<AuthFailureListener> ipAuthFailureListeners = ImmutableList.empty();

    public SessionService(ConfigurationRepository configurationRepository, PrivilegedConfigClient privilegedConfigClient, StaticSettings settings, PrivilegesEvaluator privilegesEvaluator, AuditLog auditLog, ThreadPool threadPool, ClusterService clusterService, ProtectedConfigIndexService protectedConfigIndexService, SessionServiceConfig config, BlockedIpRegistry blockedIpRegistry, BlockedUserRegistry blockedUserRegistry, final ComponentState componentState) {
        this.indexName = (String)settings.get(INDEX_NAME);
        this.privilegedConfigClient = privilegedConfigClient;
        this.threadPool = threadPool;
        this.componentState = componentState;
        this.configComponentState = componentState.getOrCreatePart("config", "sg_config");
        this.threadContext = threadPool.getThreadContext();
        this.adminDns = new AdminDNs(settings.getPlatformSettings());
        this.privilegesEvaluator = privilegesEvaluator;
        this.auditLog = auditLog;
        this.blockedIpRegistry = blockedIpRegistry;
        this.blockedUserRegistry = blockedUserRegistry;
        this.clusterService = clusterService;
        this.activityTracker = new SessionActivityTracker(config.getInactivityTimeout() != null ? config.getInactivityTimeout() : Duration.ofHours(1L), this, this.indexName, privilegedConfigClient, threadPool);
        this.componentState.addPart(this.activityTracker.getComponentState());
        this.componentState.addMetrics("start_session_with_authentication", (Measurement)this.startAuthenticatedSessionMetrics);
        this.componentState.addMetrics("start_session_with_external_authentication", (Measurement)this.startSessionMetrics);
        this.componentState.addMetrics("delete_session", (Measurement)this.deleteMetrics);
        this.setConfig(config);
        ProtectedConfigIndexService.ConfigIndex configIndex = new ProtectedConfigIndexService.ConfigIndex(this.indexName).mapping(SessionToken.INDEX_MAPPING).onIndexReady(this::init);
        componentState.addPart(protectedConfigIndexService.createIndex(configIndex));
        this.indexCleanupAgent = this.activityTracker != null ? new IndexCleanupAgent(this.indexName, () -> QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)"dynamic_expires_at").lt((Object)System.currentTimeMillis())).should((QueryBuilder)QueryBuilders.rangeQuery((String)"expires_at").lt((Object)System.currentTimeMillis())), (TimeValue)settings.get(CLEANUP_INTERVAL), (Client)privilegedConfigClient, clusterService, threadPool) : new IndexCleanupAgent(this.indexName, "expires_at", (TimeValue)settings.get(CLEANUP_INTERVAL), (Client)privilegedConfigClient, clusterService, threadPool);
        componentState.addPart(this.indexCleanupAgent.getComponentState());
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<FrontendAuthcConfig> frontendConfig = configMap.get(CType.FRONTEND_AUTHC);
                SgDynamicConfiguration<RestAuthcConfig> config = configMap.get(CType.AUTHC);
                SgDynamicConfiguration<LegacySgConfig> legacyConfig = configMap.get(CType.CONFIG);
                RestAuthcConfig restAuthcConfig = null;
                if (config != null && config.getCEntry("default") != null) {
                    restAuthcConfig = config.getCEntry("default");
                    componentState.replacePartsWithType("config", config.getComponentState());
                } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                    restAuthcConfig = legacyConfig.getCEntry("sg_config").getRestAuthcConfig();
                    componentState.replacePartsWithType("config", legacyConfig.getComponentState());
                } else {
                    componentState.setState(ComponentState.State.SUSPENDED, "no_configuration");
                }
                if (frontendConfig != null) {
                    componentState.addPart(frontendConfig.getComponentState());
                }
                if (log.isDebugEnabled()) {
                    log.debug("New configuration:\nFrontendConfig: " + frontendConfig + "\nRestAuthcConfig: " + restAuthcConfig);
                }
                MergedAuthcConfig authcConfig = new MergedAuthcConfig(frontendConfig, restAuthcConfig);
                SessionService.this.authcConfig = authcConfig;
                componentState.replacePartsWithType("auth_domain", (Collection)authcConfig.getAuthenticationDomains().stream().map(d -> d.getComponentState()).collect(Collectors.toList()));
                SessionService.this.clientAddressAscertainer = ClientAddressAscertainer.create(restAuthcConfig != null ? restAuthcConfig.getNetwork() : null);
                SessionService.this.configComponentState.initialized();
                componentState.updateStateFromParts();
            }
        });
    }

    public void authenticateAndCreateSession(Map<String, Object> request, RestRequest restRequest, Consumer<SessionApi.StartSessionResponse> onResult, Consumer<AuthcResult> onAuthFailure, Consumer<Exception> onFailure) {
        if (this.config == null) {
            onFailure.accept(new SessionCreationException("SessionService is not configured", RestStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        Meter meter = Meter.basic((MetricsLevel)this.getMetricsLevel(), (TimeAggregation)this.startAuthenticatedSessionMetrics);
        this.authenticate(request, restRequest, this.config.getRequiredLoginPrivileges(), authcResult -> {
            if (authcResult.getStatus() == AuthcResult.Status.PASS) {
                this.threadPool.generic().submit(() -> {
                    try {
                        SessionApi.StartSessionResponse response = this.createLightweightJwt(authcResult.getUser(), authcResult.getRedirectUri(), meter);
                        meter.close();
                        this.auditLog.logSucceededKibanaLogin(authcResult.getUser());
                        onResult.accept(response);
                    }
                    catch (SessionCreationException e) {
                        meter.close();
                        log.info("Creating token failed", (Throwable)e);
                        onAuthFailure.accept(AuthcResult.stop(e.getRestStatus(), e.getMessage()));
                    }
                    catch (Exception e) {
                        meter.close();
                        onFailure.accept(e);
                    }
                });
            } else {
                meter.close();
                onAuthFailure.accept((AuthcResult)authcResult);
            }
        }, meter.consumer(onFailure), meter);
    }

    public CompletableFuture<SessionApi.StartSessionResponse> createSession(User user) {
        CompletableFuture<SessionApi.StartSessionResponse> result = new CompletableFuture<SessionApi.StartSessionResponse>();
        Meter meter = Meter.basic((MetricsLevel)this.getMetricsLevel(), (TimeAggregation)this.startSessionMetrics);
        this.threadPool.generic().submit(() -> {
            try {
                SessionApi.StartSessionResponse response = this.createLightweightJwt(user, null, meter);
                this.auditLog.logSucceededKibanaLogin(user);
                result.complete(response);
            }
            catch (Exception e) {
                log.error("Creating token failed", (Throwable)e);
                result.completeExceptionally(e);
            }
            finally {
                meter.close();
            }
        });
        return result;
    }

    public String getSsoLogoutUrl(User user) {
        Object apiAuthenticationDomains;
        String authType = user.getAttributeAsString("__auth_type");
        if (authType == null) {
            return (String)this.threadPool.getThreadContext().getTransient("_sg_sso_logout_url");
        }
        String frontendConfigId = user.getAttributeAsString("__fe_cnf_id");
        if (frontendConfigId == null) {
            frontendConfigId = "default";
        }
        if ((apiAuthenticationDomains = this.authcConfig.get(frontendConfigId)) == null) {
            log.error("Cannot determine logoutUrl because frontend config " + frontendConfigId + " is not known: " + user);
            return null;
        }
        apiAuthenticationDomains = apiAuthenticationDomains.stream().filter(d -> authType.equals(((ApiAuthenticationFrontend)d.getFrontend()).getType())).collect(Collectors.toList());
        Iterator iterator = apiAuthenticationDomains.iterator();
        while (iterator.hasNext()) {
            AuthenticationDomain domain = (AuthenticationDomain)iterator.next();
            try {
                String logoutUrl = ((ApiAuthenticationFrontend)domain.getFrontend()).getLogoutUrl(user);
                if (logoutUrl == null) continue;
                return logoutUrl;
            }
            catch (Exception e) {
                log.error("Error while determining logoutUrl via " + domain, (Throwable)e);
            }
        }
        return null;
    }

    private void authenticate(Map<String, Object> request, RestRequest restRequest, List<String> requiredLoginPrivileges, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure, Meter meter) {
        String id;
        String mode;
        Meter subMeter = meter.basic("authenticate");
        ClientAddressAscertainer.ClientIpInfo clientInfo = this.clientAddressAscertainer.getActualRemoteAddress(restRequest);
        IPAddress remoteIpAddress = clientInfo.getOriginatingIpAddress();
        if (log.isTraceEnabled()) {
            log.trace("Rest authentication request from {} [original: {}]", (Object)remoteIpAddress, (Object)restRequest.getHttpChannel().getRemoteAddress());
        }
        if (clientInfo.isTrustedProxy()) {
            this.threadContext.putTransient("_sg_xff_done", (Object)Boolean.TRUE);
        }
        this.threadContext.putTransient("_sg_remote_address", (Object)clientInfo.getOriginatingTransportAddress());
        if (this.blockedIpRegistry.isIpBlocked(remoteIpAddress)) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting REST request because of blocked address: " + remoteIpAddress);
            }
            subMeter.close();
            this.auditLog.logBlockedIp(restRequest, clientInfo.getOriginatingTransportAddress().address());
            onResult.accept(new AuthcResult(AuthcResult.Status.STOP, RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return;
        }
        String configId = request.get("config_id") != null ? request.get("config_id").toString() : "default";
        Object apiAuthenticationDomains = this.authcConfig.get(configId);
        if (apiAuthenticationDomains == null) {
            log.error("Invalid config_id: " + configId + "; available: " + this.authcConfig);
            subMeter.close();
            onResult.accept(new AuthcResult(AuthcResult.Status.STOP, RestStatus.BAD_REQUEST, "Invalid config_id"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Using auth domains from frontend config " + configId + ": " + apiAuthenticationDomains);
        }
        String string = mode = request.get("mode") != null ? request.get("mode").toString() : null;
        if (mode != null) {
            apiAuthenticationDomains = apiAuthenticationDomains.stream().filter(d -> mode.equals(((ApiAuthenticationFrontend)d.getFrontend()).getType())).collect(Collectors.toList());
        }
        String string2 = id = request.get("id") != null ? request.get("id").toString() : null;
        if (id != null) {
            apiAuthenticationDomains = apiAuthenticationDomains.stream().filter(d -> id.equals(d.getId())).collect(Collectors.toList());
        }
        if (log.isDebugEnabled()) {
            log.debug("Auth domains after filtering by mode " + mode + " and id " + id + ": " + apiAuthenticationDomains);
        }
        RestRequestMetaData requestMetaData = new RestRequestMetaData(restRequest, remoteIpAddress, null);
        new ApiAuthenticationProcessor(request, requestMetaData, (Collection<AuthenticationDomain<ApiAuthenticationFrontend>>)apiAuthenticationDomains, this.adminDns, this.privilegesEvaluator, this.auditLog, this.blockedUserRegistry, this.ipAuthFailureListeners, requiredLoginPrivileges, this.authcConfig.isDebugEnabled(configId)).authenticate(subMeter.consumer(onResult), subMeter.consumer(onFailure));
    }

    private SessionApi.StartSessionResponse createLightweightJwt(User user, String redirectUri, Meter meter) throws SessionCreationException {
        String encodedJwt;
        if (this.jwtProducer == null) {
            throw new SessionCreationException("SessionService is not configured", RestStatus.INTERNAL_SERVER_ERROR);
        }
        SessionToken sessionToken = this.create(user, meter);
        JwtClaims jwtClaims = new JwtClaims();
        JwtToken jwt = new JwtToken(jwtClaims);
        jwtClaims.setNotBefore(Long.valueOf(sessionToken.getCreationTime().getEpochSecond()));
        if (sessionToken.getExpiryTime() != null) {
            jwtClaims.setExpiryTime(Long.valueOf(sessionToken.getExpiryTime().getEpochSecond()));
        }
        jwtClaims.setSubject(user.getName());
        jwtClaims.setTokenId(sessionToken.getId());
        jwtClaims.setAudience(this.jwtAudience);
        try {
            encodedJwt = this.jwtProducer.processJwt(jwt);
        }
        catch (Exception e) {
            log.error("Error while creating JWT. Possibly the key configuration is not valid.", (Throwable)e);
            throw new SessionCreationException("Error while creating JWT. Possibly the key configuration is not valid.", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
        return new SessionApi.StartSessionResponse(encodedJwt, redirectUri);
    }

    public SessionToken getById(String id, Meter meter) throws NoSuchSessionException {
        SessionToken result = (SessionToken)this.idToAuthTokenMap.getIfPresent((Object)id);
        if (result != null) {
            return result;
        }
        return this.getByIdFromIndex(id, meter);
    }

    public void getById(String id, Consumer<SessionToken> onResult, Consumer<NoSuchSessionException> onNoSuchAuthToken, Consumer<Exception> onFailure, Meter meter) {
        SessionToken result = (SessionToken)this.idToAuthTokenMap.getIfPresent((Object)id);
        if (result != null) {
            onResult.accept(result);
        } else {
            this.getByIdFromIndex(id, onResult, onNoSuchAuthToken, onFailure, meter);
        }
    }

    public SessionToken getByIdFromIndex(String id, Meter meter) throws NoSuchSessionException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getByIdFromIndex(id, completableFuture::complete, completableFuture::completeExceptionally, completableFuture::completeExceptionally, meter);
        try {
            return (SessionToken)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchSessionException) {
                throw (NoSuchSessionException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void getByIdFromIndex(final String id, final Consumer<SessionToken> onResult, final Consumer<NoSuchSessionException> onNoSuchSession, final Consumer<Exception> onFailure, Meter meter) {
        final Meter subMeter = meter.basic("index_read_by_id");
        this.privilegedConfigClient.get(new GetRequest(this.indexName, id), (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (log.isTraceEnabled()) {
                    log.trace("SessionService.getByIdFromIndex(" + id + ") =>\n" + Strings.toString((ToXContent)getResponse));
                }
                if (getResponse.isExists()) {
                    try {
                        SessionToken sessionToken = SessionToken.parse(id, DocNode.parse((Format)Format.JSON).from(getResponse.getSourceAsString()));
                        SessionService.this.idToAuthTokenMap.put((Object)id, (Object)sessionToken);
                        subMeter.close();
                        onResult.accept(sessionToken);
                    }
                    catch (ConfigValidationException e) {
                        subMeter.close();
                        onFailure.accept(new RuntimeException("Token " + id + " is not stored in a valid format", e));
                    }
                    catch (Exception e) {
                        subMeter.close();
                        log.error((Object)e);
                        onFailure.accept(e);
                    }
                } else {
                    subMeter.close();
                    onNoSuchSession.accept(new NoSuchSessionException(id));
                }
            }

            public void onFailure(Exception e) {
                subMeter.close();
                if (e instanceof IndexNotFoundException) {
                    onNoSuchSession.accept(new NoSuchSessionException(id));
                } else {
                    onFailure.accept(e);
                }
            }
        });
    }

    public String delete(User user, SessionToken sessionToken) throws NoSuchSessionException, SessionUpdateException {
        try (Meter meter = Meter.basic((MetricsLevel)this.getMetricsLevel(), (TimeAggregation)this.deleteMetrics);){
            if (log.isTraceEnabled()) {
                log.trace("delete(" + user + ", " + sessionToken.getId() + ")");
            }
            if ((sessionToken = this.getById(sessionToken.getId(), meter)).getRevokedAt() != null) {
                log.info("Session token " + sessionToken + " was already revoked");
                String string = "Session token was already revoked";
                return string;
            }
            String updateStatus = this.updateSessionToken(sessionToken.getRevokedInstance(), PushSessionTokenUpdateAction.Request.UpdateType.REVOKED, meter);
            this.auditLog.logSucceededKibanaLogout(user);
            if (updateStatus != null) {
                String string = updateStatus;
                return string;
            }
            String string = "Sesion has been deleted";
            return string;
        }
    }

    public SessionToken getByClaims(Map<String, Object> claims, Meter meter) throws NoSuchSessionException, InvalidTokenException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getByClaims(claims, completableFuture::complete, completableFuture::completeExceptionally, completableFuture::completeExceptionally, meter);
        try {
            return (SessionToken)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchSessionException) {
                throw (NoSuchSessionException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void getByClaims(Map<String, Object> claims, Consumer<SessionToken> onResult, Consumer<NoSuchSessionException> onNoSuchAuthToken, Consumer<Exception> onFailure, Meter meter) throws InvalidTokenException {
        String id = Objects.toString(claims.get("jti"), null);
        Set<String> audience = this.getClaimAsSet(claims, "aud");
        if (!audience.contains(this.jwtAudience)) {
            throw new InvalidTokenException("Invalid JWT audience claim. Supplied: " + audience + "; Expected: " + this.jwtAudience);
        }
        if (id == null) {
            throw new InvalidTokenException("Supplied auth token does not have an id claim");
        }
        this.getById(id, onResult, onNoSuchAuthToken, onFailure, meter);
    }

    private Set<String> getClaimAsSet(Map<String, Object> claims, String claimName) {
        Object claim = claims.get(claimName);
        if (claim == null) {
            return Collections.emptySet();
        }
        if (claim instanceof Collection) {
            return ((Collection)claim).stream().map(e -> String.valueOf(e)).collect(Collectors.toSet());
        }
        return Collections.singleton(String.valueOf(claim));
    }

    private SessionToken create(User user, Meter meter) throws SessionCreationException {
        long existingTokenCount;
        if (this.config == null || !this.config.isEnabled()) {
            throw new SessionCreationException("Session token handling is not enabled", RestStatus.INTERNAL_SERVER_ERROR);
        }
        if (log.isDebugEnabled()) {
            log.debug("create(user: " + user.toStringWithAttributes() + ")");
        }
        Set<String> baseBackendRoles = user.getRoles();
        Set<String> baseSearchGuardRoles = user.getSearchGuardRoles();
        Map<String, Object> baseAttributes = user.getStructuredAttributes();
        String id = this.getRandomId();
        SessionPrivileges base = new SessionPrivileges(baseBackendRoles, baseSearchGuardRoles, baseAttributes);
        if (this.maxTokensPerUser == 0L) {
            throw new SessionCreationException("Cannot create token. max_tokens_per_user is set to 0", RestStatus.FORBIDDEN);
        }
        if (this.maxTokensPerUser > 0L && (existingTokenCount = this.countSessionsOfUser(user)) + 1L > this.maxTokensPerUser) {
            throw new SessionCreationException("Cannot create session. Session limit per user exceeded. Max number of allowed sessions is " + this.maxTokensPerUser, RestStatus.FORBIDDEN);
        }
        OffsetDateTime now = OffsetDateTime.now().withNano(0);
        OffsetDateTime expiresAt = this.getExpiryTime(now);
        OffsetDateTime dynamicExpiresAt = null;
        if (this.activityTracker != null) {
            dynamicExpiresAt = now.plus(this.activityTracker.getInactivityTimeout());
        }
        SessionToken sessionToken = new SessionToken(id, user.getName(), base, now.toInstant(), expiresAt != null ? expiresAt.toInstant() : null, dynamicExpiresAt != null ? dynamicExpiresAt.toInstant() : null, null);
        try {
            this.updateSessionToken(sessionToken, PushSessionTokenUpdateAction.Request.UpdateType.NEW, meter);
        }
        catch (Exception e) {
            this.componentState.addLastException("create", (Throwable)e);
            throw new SessionCreationException("Error while creating token", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
        return sessionToken;
    }

    private String getRandomId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String result = BaseEncoding.base64Url().encode(byteBuffer.array()).replace("=", "");
        return result;
    }

    private long countSessionsOfUser(User user) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"user_name", (String)user.getName())).size(0));
        SearchResponse searchResponse = (SearchResponse)this.privilegedConfigClient.search(searchRequest).actionGet();
        return searchResponse.getHits().getTotalHits().value;
    }

    private OffsetDateTime getExpiryTime(OffsetDateTime now) {
        OffsetDateTime expiresAfter = null;
        if (this.config.getMaxValidity() != null) {
            expiresAfter = now.plus(this.config.getMaxValidity());
        }
        return expiresAfter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String updateSessionToken(SessionToken sessionToken, PushSessionTokenUpdateAction.Request.UpdateType updateType, Meter meter) throws SessionUpdateException {
        SessionToken oldToken = null;
        try {
            oldToken = this.getById(sessionToken.getId(), meter);
        }
        catch (NoSuchSessionException e) {
            oldToken = null;
        }
        if (updateType == PushSessionTokenUpdateAction.Request.UpdateType.NEW && oldToken != null) {
            throw new SessionUpdateException("Token ID already exists: " + sessionToken.getId());
        }
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
             Meter subMeter2 = meter.basic("index_update");){
            sessionToken.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            IndexResponse indexResponse = (IndexResponse)this.privilegedConfigClient.index((IndexRequest)new IndexRequest(this.indexName).id(sessionToken.getId()).source(xContentBuilder).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
            if (log.isDebugEnabled()) {
                log.debug("Token stored: " + indexResponse);
            }
        }
        catch (Exception e) {
            if (oldToken != null) {
                this.idToAuthTokenMap.put((Object)oldToken.getId(), (Object)oldToken);
            } else {
                this.idToAuthTokenMap.invalidate((Object)sessionToken.getId());
            }
            log.warn("Error while storing token " + sessionToken, (Throwable)e);
            throw new SessionUpdateException(e);
        }
        try (Meter subMeter = meter.basic("cluster_update");){
            PushSessionTokenUpdateAction.Response pushAuthTokenUpdateResponse = (PushSessionTokenUpdateAction.Response)((Object)this.privilegedConfigClient.execute(PushSessionTokenUpdateAction.INSTANCE, (ActionRequest)new PushSessionTokenUpdateAction.Request(sessionToken, updateType, 0L)).actionGet());
            if (log.isDebugEnabled()) {
                log.debug("Token update pushed: " + (Object)((Object)pushAuthTokenUpdateResponse));
            }
            if (!pushAuthTokenUpdateResponse.hasFailures()) return null;
            String string = "Update partially failed: " + pushAuthTokenUpdateResponse.failures();
            return string;
        }
        catch (Exception e) {
            log.warn("Token update push failed: " + sessionToken, (Throwable)e);
            return "Update partially failed: " + e;
        }
    }

    public JwtToken getVerifiedJwtToken(String encodedJwt) throws JwtException {
        boolean signatureValid;
        JwsJwtCompactConsumer jwtConsumer;
        JwtToken jwt;
        if (this.jweDecryptionProvider != null) {
            JweDecryptionOutput decOutput = this.jweDecryptionProvider.decrypt(encodedJwt);
            encodedJwt = decOutput.getContentText();
        }
        if (!this.validateAudience((jwt = (jwtConsumer = new JwsJwtCompactConsumer(encodedJwt)).getJwtToken()).getClaims())) {
            if (log.isTraceEnabled()) {
                log.trace("Not checking this token because it has a different audience: " + jwt.getClaims().getAudience());
            }
            return null;
        }
        if (this.jwsSignatureVerifier != null && !(signatureValid = jwtConsumer.verifySignatureWith(this.jwsSignatureVerifier))) {
            throw new JwtException("Invalid JWT signature for token " + jwt.getClaims().asMap());
        }
        this.validateClaims(jwt);
        return jwt;
    }

    private void validateClaims(JwtToken jwt) throws JwtException {
        JwtClaims claims = jwt.getClaims();
        if (claims == null) {
            throw new JwtException("The JWT does not have any claims");
        }
        JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)0, (boolean)false);
        JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)0, (boolean)false);
    }

    private boolean validateAudience(JwtClaims claims) throws JwtException {
        for (String audience : claims.getAudiences()) {
            if (!this.jwtAudience.equals(audience)) continue;
            return true;
        }
        return false;
    }

    void checkExpiryAndTrackAccess(SessionToken sessionToken, Consumer<Boolean> onResult, Consumer<Exception> onFailure, Meter meter) {
        this.activityTracker.checkExpiryAndTrackAccess(sessionToken, onResult, onFailure, meter);
    }

    public void setConfig(SessionServiceConfig config) {
        if (config == null) {
            return;
        }
        this.config = config;
        this.maxTokensPerUser = config.getMaxSessionsPerUser();
        if (config.getJwtAudience() != null) {
            try {
                this.jwtAudience = (String)config.getJwtAudience().render(AttributeSource.of((String)"cluster.name", (Object)this.clusterService.getClusterName()));
            }
            catch (ExpressionEvaluationException e) {
                log.error("Invalid configuration for jwt_audience: " + config.getJwtAudience(), (Throwable)e);
                this.jwtAudience = "sg_session_" + this.clusterService.getClusterName();
                this.componentState.addLastException("jwt_audience", (Throwable)e);
            }
        } else {
            this.jwtAudience = "sg_session_" + this.clusterService.getClusterName();
        }
        this.setKeys(config.getJwtSigningKey(), config.getJwtEncryptionKey());
        this.activityTracker.setInactivityTimeout(config.getInactivityTimeout() != null ? config.getInactivityTimeout() : Duration.ofHours(1L));
        this.activityTracker.setIndexRefreshPolicy(config.isRefreshSessionActivityIndex() ? WriteRequest.RefreshPolicy.IMMEDIATE : WriteRequest.RefreshPolicy.NONE);
    }

    public void shutdown() {
        this.indexCleanupAgent.shutdown();
    }

    public String pushAuthTokenUpdate(PushSessionTokenUpdateAction.Request request) {
        SessionToken updatedSessionToken;
        SessionToken existingSessionToken;
        if (log.isDebugEnabled()) {
            log.debug("got auth token update: " + (Object)((Object)request));
        }
        if ((existingSessionToken = (SessionToken)this.idToAuthTokenMap.getIfPresent((Object)(updatedSessionToken = request.getUpdatedToken()).getId())) == null) {
            return "Session token is not cached";
        }
        this.idToAuthTokenMap.put((Object)updatedSessionToken.getId(), (Object)updatedSessionToken);
        return "Session token updated";
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    MetricsLevel getMetricsLevel() {
        return this.config.getMetricsLevel();
    }

    void initJwtProducer() {
        try {
            this.jwtProducer = new JoseJwtProducer();
            if (this.signingKey != null) {
                this.jwtProducer.setSignatureProvider(JwsUtils.getSignatureProvider((JsonWebKey)this.signingKey));
                this.jwsSignatureVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)this.signingKey);
            } else {
                this.jwsSignatureVerifier = null;
            }
            if (this.encryptionKey != null) {
                this.jwtProducer.setEncryptionProvider(JweUtils.createJweEncryptionProvider((JsonWebKey)this.encryptionKey, (ContentAlgorithm)ContentAlgorithm.A256CBC_HS512));
                this.jwtProducer.setJweRequired(true);
                this.jweDecryptionProvider = JweUtils.createJweDecryptionProvider((JsonWebKey)this.encryptionKey, (ContentAlgorithm)ContentAlgorithm.A256CBC_HS512);
            } else {
                this.jweDecryptionProvider = null;
            }
        }
        catch (Exception e) {
            this.configComponentState.setFailed((Throwable)e);
            this.jwtProducer = null;
            log.error("Error while initializing JWT producer in AuthTokenProvider", (Throwable)e);
        }
    }

    public JsonWebKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(JsonWebKey signingKey) {
        if (Objects.equals(this.signingKey, signingKey)) {
            return;
        }
        log.info("Updating signing key for " + this);
        this.signingKey = signingKey;
        this.initJwtProducer();
    }

    public JsonWebKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(JsonWebKey encryptionKey) {
        if (Objects.equals(this.encryptionKey, encryptionKey)) {
            return;
        }
        log.info("Updating encryption key for " + this);
        this.encryptionKey = encryptionKey;
        this.initJwtProducer();
    }

    public void setKeys(JsonWebKey signingKey, JsonWebKey encryptionKey) {
        if (Objects.equals(this.signingKey, signingKey) && Objects.equals(this.encryptionKey, encryptionKey)) {
            return;
        }
        log.info("Updating keys for " + this);
        this.signingKey = signingKey;
        this.encryptionKey = encryptionKey;
        this.initJwtProducer();
    }

    private void init(ProtectedConfigIndexService.FailureListener failureListener) {
        this.initComplete();
        failureListener.onSuccess();
        this.componentState.updateStateFromParts();
    }

    private synchronized void initComplete() {
        this.initialized = true;
        this.notifyAll();
    }

    public synchronized void waitForInitComplete(long timeoutMillis) {
        if (this.initialized) {
            return;
        }
        try {
            this.wait(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.initialized) {
            throw new RuntimeException(this + " did not initialize after " + timeoutMillis);
        }
    }
}

